### 55.1.5. 自定义"grab"元数据

Spring Boot提供一个新的`@GrabMetadata`注解，你可以使用它提供自定义的依赖元数据，以覆盖Spring Boot的默认配置。该元数据通过使用提供一个或多个配置文件坐标的注解来指定（使用一个属性标识符"type"部署到Maven仓库）.。配置文件中的每个实体必须遵循`group:module=version`的格式。

例如，下面的声明：
```java
`@GrabMetadata("com.example.custom-versions:1.0.0")`
```
将会加载Maven仓库处于`com/example/custom-versions/1.0.0/`下的`custom-versions-1.0.0.properties`文件。

可以通过注解指定多个属性文件，它们会以声明的顺序被使用。例如：
```java
`@GrabMetadata(["com.example.custom-versions:1.0.0",
        "com.example.more-versions:1.0.0"])`
```
意味着位于`more-versions`的属性将覆盖位于`custom-versions`的属性。

你可以在任何能够使用`@Grab`的地方使用`@GrabMetadata`，然而，为了确保元数据的顺序一致，你在应用程序中最多只能使用一次`@GrabMetadata`。[Spring IO Platform](http://platform.spring.io/)是一个非常有用的依赖元数据源(Spring Boot的超集)，例如：
```java
@GrabMetadata('io.spring.platform:platform-versions:1.0.4.RELEASE')
```
